function  centers=DetectPeaks(img, background,edg)

% Analyzes 2D images to detect peaks , finds x-y positions of peaks to 1 pixel accuracy
%
% Inputs:
%   img          The 2D data raw image 
%   background  A number between 0 and max(raw_image(:)) to remove  background
%   edg         A number>1 for skipping the first few and the last few 'edge' pixels

%
% Output:
%   centers        a 1xN vector of coordinates of peaks (x1,y1,x2,y2,...)

%This code is an adaptation of the skeleton http://www.mathworks.com/matlabcentral/fileexchange/37388-fast-2d-peak-finder/content/FastPeakFind.m

%% argcheck

if ~exist('img','var')
    disp('ERROR:Input image not provided. Exiting ... ');
    return
end

if isfloat(img) %For the case the input image is double, casting to uint16 keeps enough dynamic range while speeds up the code.
    img =  uint16( img.*2^16./(max(img(:))));
end

if (nargin < 2)
    background = (max([min(max(img,[],1))  min(max(img,[],2))])) ; 
end

if (nargin < 3)
    edg =3;
end


%% Analyze image
if any(img(:))  ; %for the case of non zero raw image
    
    
    % apply threshold
    img=img.*uint16(img>background);
    
    if any(img(:))   ; %for the case of the image is still non zero
        
      
        % img will be noisy on the edges, we'll skip 'edge' pixels.
        
        [x y]=find(img(edg:size(img,1)-edg,edg:size(img,2)-edg));
        
        % initialize peak find outputs
        centers=[];
        x=x+edg-1;
        y=y+edg-1;
        for j=1:length(y)
            if (img(x(j),y(j))>=img(x(j)-1,y(j)-1 )) &&...
                    (img(x(j),y(j))>img(x(j)-1,y(j))) &&...
                    (img(x(j),y(j))>=img(x(j)-1,y(j)+1)) &&...
                    (img(x(j),y(j))>img(x(j),y(j)-1)) && ...
                    (img(x(j),y(j))>img(x(j),y(j)+1)) && ...
                    (img(x(j),y(j))>=img(x(j)+1,y(j)-1)) && ...
                    (img(x(j),y(j))>img(x(j)+1,y(j))) && ...
                    (img(x(j),y(j))>=img(x(j)+1,y(j)+1));
                
    
                centers = [centers ; x(j) ; y(j)];                    
            end
        end
        
        
    else % in case image after threshold is all zeros
        centers=[];
        return
    end
    
else % in case raw image is all zeros (dead event)
    centers=[];
    return
end
